﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Kalend;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;
using Soneta.Langs;

namespace ASP {

    public partial class Urlopy_Plan : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_NaRok = "na {0} rok";
        public string Str_OkresAll = "(wszystko)";

        public class PrnParams: ContextBase {
	
		    public PrnParams(Context context): base(context) {
			    UstawRok();
                definicja = KalendModule.GetInstance(this).DefinicjeLimitow.UrlopWypoczynkowy;
		    }

            FromTo okres;
            [Caption("Plan urlopów za okres")]
		    [Soneta.Business.Required]
            [Priority(10)]
            public FromTo Okres {
                get { return okres; }
                set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    okres = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            DefinicjaLimitu definicja;
            [Caption("Nieobecność")]
		    [Soneta.Business.Required]
            [Priority(20)]
            public DefinicjaLimitu Nieobecność {
                get { return definicja; }
                set {
                    definicja = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public object GetListNieobecność() {
                Soneta.Business.View view = KalendModule.GetInstance(this).DefinicjeLimitow.WgNazwy.CreateView();
                view.Condition &= new FieldCondition.Equal("Naliczanie", NaliczanieLimitu.WypoczynkowyNaGodziny);
                return view;
            } 
       		
		    void UstawRok() {
			    Date data;
			    if (Context.Contains(typeof(ActualDate)))
				    data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			    else
				    data = Date.Today;
			    okres = FromTo.Year(data.Year);
		    }
	    }
	
	    PrnParams pars = null; 
	    [Context(Required=true)] 
	    public PrnParams Params { 
		    set { pars = value; } 
	    } 

	    KalendModule kalend;
	    DefinicjaLimitu definicja;
	
	    protected void OnContextLoad(Object sender, EventArgs args) {

		    if (pars.Okres == FromTo.Year(pars.Okres.To.Year))
			    ReportHeader1["OKRES"] = String.Format(Str_NaRok, pars.Okres.To.Year.ToString());
		    else
			    ReportHeader1["OKRES"] = String.Format(Str_NaRok, ((pars.Okres != FromTo.All) ? pars.Okres.ToString() : Str_OkresAll));

            kalend = KalendModule.GetInstance(dc);
		    definicja = pars.Nieobecność;

            ReportHeader1["DEFINICJA"] = definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo));

            // Odczytanie listy pracowników podległych z kontekstu
            Row[] rows = getRows();

		    ArrayList result = new ArrayList();
            foreach (Pracownik prac in rows) {
                PracHistoria ph = prac[pars.Okres.To];
                result.Add(ph);
            }
		    Grid1.DataSource = result;
	    }

        protected void Grid1_BeforeRow(Object sender, Soneta.Web.RowEventArgs args) {
		    PracHistoria ph = (PracHistoria)args.Row;

            if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowy ||
                ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą) {
                args.VisibleRow = false;
                return;
            }
        
		    bool pierwszy = true;
		    double dZal = 0;
		    Time tZal = Time.Zero;
		    decimal dBierz = 0;
		    Date data = Date.Empty;
		    Time tBierz = Time.Zero;
            Time kBierz = Time.Zero;
		    Time tPoz = Time.Zero;
		    double dPoz = 0;
		
		    IEnumerable limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][pars.Okres];
            foreach (LimitNieobecnosci l in limity) {
                if (pierwszy) {
                    pierwszy = false;
                    if (l.Przeniesienie != 0)
                        dZal = l.Przeniesienie;
                    else {
                        tZal = l.PrzeniesienieGodz;
                        data = l.Okres.To;
                    }
                }

                if (l.Typ == TypLimituNieobecności.UrlopWypoczynkowy)
                    dBierz += l.PodstawaGodz;       //TID: 2052
                else
                    dBierz += l.Limit + l.Zmiana + l.Korekta;
                tBierz += l.LimitGodz;
			    kBierz += l.ZmianaGodz - l.WykorzystanyPoprzGodz;
                tPoz = l.PozostaloGodz;
                dPoz = l.PozostaloDni;
            }	
		
		    if (tZal!=Time.Zero) {
                Fraction wymiar = ph.Pracownik[data].Etat.Wymiar;
                if (wymiar==Fraction.Zero)
                    wymiar = Fraction.One;

                Time norma = ph.Pracownik[data].Etat.Kalendarz.NormaDobowa;
                if (norma==Time.Zero)
                    norma = new Time(8, 0);
                
                dZal = Soneta.Tools.Math.Round(tZal / norma / wymiar, 2);
		    }
		
		    zaległyD.EditValue = dZal;
		    zaległyG.EditValue = tZal;
		    limitD.EditValue = (double)dBierz;
		    limitG.EditValue = tBierz;
            limitK.EditValue = kBierz;
		    resztaG.EditValue = tPoz;
		    resztaD.EditValue = Soneta.Tools.Math.RoundCy(dPoz);

		    KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
		    IEnumerable nieobecności = kalk.Nieobecnosci(pars.Okres, true);
		    ArrayList result = new ArrayList();
		    foreach (OkresNieobecności n in nieobecności)
			    if (n.Definicja.Limit != null && definicja != null)
				    if (n.Definicja.Limit.Guid == definicja.Guid)
					    result.Add(n);

		    string s14 = "";
		    string sp = "";
		    string sd = "";
		    foreach (OkresNieobecności n in result) {
			    if (n.Okres.Days>=14) {
				    s14 += "<br>" + n.Okres.ToString();
				    sp += "<br>";				
			    }
			    else {
				    s14 += "<br>";				
				    sp += "<br>" + n.Okres.ToString();
 			    }
 			    sd += "<br>" + n.Norma().Czas;
 		    }
		    termin14.EditValue = s14=="" ? "" : s14.Substring(4, s14.Length-4);
		    termin.EditValue = sp=="" ? "" : sp.Substring(4, sp.Length-4);
		    urlopG.EditValue = sd=="" ? "" : sd.Substring(4, sd.Length-4);
        }

	    private Row[] getRows() {
            IWebUser wu = dc.Context.Login.WebUserOperatingInstance;
            if (wu == null)
                return (Row[])dc[typeof(Row[])];

            List<Pracownik> list = new List<Pracownik>();
            Pracownik[] result = null;

            PodwladniKalkulator kalkPodwladni = new PodwladniKalkulator(dc.Context, wu.Host.ID);

            KadryModule module = KadryModule.GetInstance(dc);
            Soneta.Business.View view = module.Pracownicy.WgNazwiska.CreateView();
            // Warunek dla Etat
            RowCondition rcEtat = kalkPodwladni.FiltrEtatu(pars.Okres, null);
            // Pracownicy, Pracownicy młodociani (etat, umowa)
            view.Condition &= rcEtat;
            // Warunek dla Niezatrudnionych
            kalkPodwladni.UwzgledniajNiezatrudnionych = false;
            // Uwzględnij podwładnych
            IWebUser wo = dc.Context.Login.WebUserInstance;
            view.Condition &= kalkPodwladni.PrzeliczFiltr(wu==wo);
            view.ForceAllRows();
            foreach (Pracownik prac in view)
                list.Add(prac);
            result = list.ToArray();

            return result;
        }
    }
}
